#Sets the Legal Text back to the Environment Defaults after IPU Complete.  Logs to WaaS_PostActions.log

#Update $RegistryPath Value for your Environment.
$LogFileLocation = "C:\Windows\ccm\Logs"
$LogFileNamePostAction = "WaaS_PostActions.log"
$LogFileNameOSUninstall = "WaaS_OSUninstall.log"
$LogFile = "$LogFileLocation\$LogFileNamePostAction"
$RegistryPath = "HKLM:SOFTWARE\WaaS"
$CurrentBuild = Get-ItemPropertyValue "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion" 'CurrentBuild' -ErrorAction SilentlyContinue
$legalnoticecaption = "WARNING"
$legalnoticetext = "WARNING. You have accessed a private computer system. Unauthorized access, use, connection, or entry is not permitted and constitutes a crime punishable by law. We reserve the right to fully pursue criminal and civil legal penalties. All individuals using this computer system with or without proper authority are subject to having all their activities monitored and recorded. Anyone using this system implicitly consents to this monitoring. Any evidence of suspected criminal activity revealed by such monitoring may be provided to law enforcement officials."



# Schedule Task Names
$DefaultSTN = "WaaS_SetLegalNoticeText-Default"
$OSUpgradeCompleteSTN = "WaaS_SetLegalNoticeText-OSUpgradeComplete"
$OSUninstallSuccessfulSTN = "WaaS_SetLegalNoticeText-OSUninstallSuccessful"
$OSUninstallSTN = "WaaS_SetLegalNoticeText-OSUninstall"
$OSUninstallDefaultSTN = "WaaS_SetLegalNoticeText-OSUninstallDefault"
$RollBackRecoverySTN = "WaaS_SetLegalNoticeText-RollBackRecovery"
$RollBackRecoveryDefaultSTN = "WaaS_SetLegalNoticeText-RollBackRecoveryDefault"
$RollBackRecovery_ProcessSTN = "WaaS_RollBackRecovery_Process"

function Test-RegistryValue
{
    <# 
    .SYNOPSIS 
    Tests if a registry value exists. 
     
    .DESCRIPTION 
    The usual ways for checking if a registry value exists don't handle when a value simply has an empty or null value. This function actually checks if a key has a value with a given name. 
     
    .EXAMPLE 
    Test-RegistryKeyValue -Path 'hklm:\Software\Carbon\Test' -Name 'Title' 
     
    Returns `True` if `hklm:\Software\Carbon\Test` contains a value named 'Title'. `False` otherwise. 
    #>
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true)]
        [string]
        # The path to the registry key where the value should be set. Will be created if it doesn't exist.
        $Path,
        
        [Parameter(Mandatory=$true)]
        [string]
        # The name of the value being set.
        $Name
    )
    
    Set-StrictMode -Version 'Latest'

    #Use-CallerPreference -Cmdlet $PSCmdlet -Session $ExecutionContext.SessionState

    if( -not (Test-Path -Path $Path -PathType Container) )
    {
        return $false
    }
    
    $properties = Get-ItemProperty -Path $Path 
    if( -not $properties )
    {
        return $false
    }
    
    $member = Get-Member -InputObject $properties -Name $Name
    if( $member )
    {
        return $true
    }
    else
    {
        return $false
    }
}


if ((Test-RegistryValue -Path "$RegistryPath" -Name "OSUninstall") -eq $true){
    $OSUninstallBuild = Get-ItemPropertyValue -Path "$RegistryPath" -Name "OSUninstall"
    $RegistryPathFull = "$RegistryPath\$OSUninstallBuild"
}
Else{
    $RegistryPathFull = "$RegistryPath\$CurrentBuild"
}
$WaaSStage = Get-ItemPropertyValue "$RegistryPathFull" 'WaaS_Stage' -ErrorAction SilentlyContinue
$LegalText_DefaultIsEnabled = Get-ItemPropertyValue "$RegistryPathFull" 'LegalText_DefaultIsEnabled' -ErrorAction SilentlyContinue
if ($LegalText_DefaultIsEnabled -eq "TRUE"){
    $LegalText_DefaultCaption = Get-ItemPropertyValue "$RegistryPathFull" 'LegalText_DefaultCaption' -ErrorAction SilentlyContinue
    $LegalText_DefaultText = Get-ItemPropertyValue "$RegistryPathFull" 'LegalText_DefaultText' -ErrorAction SilentlyContinue
}

#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
 
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
 
		    [Parameter(Mandatory=$false)]
		    $Component = $env:computername,
 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
 
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
 
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

if ($WaaSStage -eq "Deployment_Success" -or $WaaSStage -eq "IPU_Success")
    {
    CMTraceLog -Message  "---Starting LegalNotice-Default Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    CMTraceLog -Message  "Waiting 2 Minutes for other processes to complete.. what process?  I don't know, just other ones" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Start-Sleep -Seconds 120
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    if ($LegalText_DefaultIsEnabled -eq "TRUE"){
        if (($LegalText_DefaultCaption -ne $null) -or ($LegalText_DefaultCaption -ne "")){
            Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Value $LegalText_DefaultCaption
        }
        else{
            Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Value $legalnoticecaption
        }
        if (($LegalText_DefaultText -ne $null) -or ($LegalText_DefaultText -ne "")){
            Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Value $LegalText_DefaultText
        }
        else{
            Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Value $legalnoticetext
        }
    }
    else {
        Remove-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Force -ErrorAction SilentlyContinue
        Remove-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Force -ErrorAction SilentlyContinue
    }
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $OSUpgradeCompleteSTN -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $OSUpgradeCompleteSTN" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $DefaultSTN  -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $DefaultSTN " -Type 1 -LogFile $LogFile -Component LegalText-Default
    CMTraceLog -Message  "---Exiting LegalNotice-Default Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    }

    #Added this to be able to use the Same Script for both Upgrades & OSUnisntall.  Had issues with timing and would delete before it ran.
    #This only Runs 1/2 of the items, referting back to default, but not removing the tasks, I don't want it to do cleanup until I know the OSUninstall Scripts are complete
    if ($WaaSStage -eq "OSUninstallStarted") #OSUninstall is set using a OSUninstall TS post Upgrade, to allow being reverted, so this will never run if this key isn't set by the OSUninstall TS
    {
    $LogFile = "$LogFileLocation\$LogFileNameOSUninstall"
    CMTraceLog -Message  "---Starting LegalNotice-Default Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Value $legalnoticecaption
    Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Value $legalnoticetext
    CMTraceLog -Message  "Updated Values: legalnoticecaption & legalnoticetext" -Type 1 -LogFile $LogFile -Component LegalText-Default
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $OSUninstallSTN -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $OSUninstallSTN" -Type 1 -LogFile $LogFile -Component LegalText-Default
    CMTraceLog -Message  "---Exiting LegalNotice-Default Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    }

    #This runs when the OSUninstall is complete, it will now cleanup after itself, removing scripts and scheduled tasks.
    if ($WaaSStage -eq "OSUninstallComplete") #OSUninstall is set using a OSUninstall TS post Upgrade, to allow being reverted, so this will never run if this key isn't set by the OSUninstall TS
    {
    $LogFile = "$LogFileLocation\$LogFileNameOSUninstall"
    CMTraceLog -Message  "---Starting LegalNotice-Default Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Value $legalnoticecaption
    Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Value $legalnoticetext
    CMTraceLog -Message  "Updated Values: legalnoticecaption & legalnoticetext" -Type 1 -LogFile $LogFile -Component LegalText-Default
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $OSUpgradeCompleteSTN -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $OSUpgradeCompleteSTN" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $OSUninstallSuccessfulSTN -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $OSUninstallSuccessfulSTN" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $DefaultSTN  -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $DefaultSTN " -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $OSUninstallSTN -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $OSUninstallSTN" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $OSUninstallDefaultSTN -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $OSUninstallDefaultSTN" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $RollBackRecoverySTN  -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $RollBackRecoverySTN" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $RollBackRecoveryDefaultSTN  -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $RollBackRecoveryDefaultSTN" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $RollBackRecovery_ProcessSTN  -Confirm:$false
    CMTraceLog -Message  "Removed Scheduled Task $RollBackRecovery_ProcessSTN" -Type 1 -LogFile $LogFile -Component LegalText-Default
    
    CMTraceLog -Message  "Triggering Scheduled OSUninstallCleanUp" -Type 1 -LogFile $LogFile -Component LegalText-Default
    CMTraceLog -Message  "---Exiting LegalNotice-Default Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Start-ScheduledTask -TaskName "OSUninstallCleanUp"
    }